unit SensorGroup01;
// ====================================================================
(*
          ()
         
   .
        
     ,      
      ,    ,
      TSensorsDesc
   // -----------------------------------------------------
    1.01. ()  , , , , 2017.
                () Source code  ..
     29.12.2017
*)
interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls,
  //  
  Sensor01;

type
  TSensorGroup01Form = class(TForm)
    Panel1: TPanel;
    Label2: TLabel;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SensorGroup01Form: TSensorGroup01Form;

// ================================================================
//     
// ================================================================
//      
// (   !)
const Max01SensorIndex = 11;

//  
// ( !)
var   SensorsArr01 : array [0..Max01SensorIndex] of TSensor;

// ================================================================
// ================================================================
implementation
{$R *.dfm}
// ================================================================
// ================================================================

// ================================================================
//      
// ================================================================
// ----------------------------------------------------------------
//        
// ( !)
type TSensorsDesc = record
  XB    : integer;     // Left -     
  YB    : integer;     // Top  -     
  Title : string;      //   
  Min   : integer;     //    
  Max   : integer;     //    
end;
// ----------------------------------------------------------------
//   
// (   !)
const SensorsDesc : array [0..Max01SensorIndex] of TSensorsDesc =
( //  
  ( XB : 10;  YB : 40;        Title : '  0'; Min : -10;  Max : 10),
  ( XB : 10;  YB : 40 + 140;  Title : '  1'; Min : -100; Max : 100),
  ( XB : 10;  YB : 40 + 280;  Title : '  2'; Min : -150; Max : 150),
  ( XB : 10;  YB : 40 + 420;  Title : '  3'; Min : -150; Max : 150),
  //  
  ( XB : 260; YB : 40;       Title : '  4';  Min : -100; Max : 100),
  ( XB : 260; YB : 40 + 140; Title : '  5';  Min : -10;  Max : 10),
  ( XB : 260; YB : 40 + 280; Title : ' ';     Min :  000; Max : 900),
  ( XB : 260; YB : 40 + 420; Title : ' ';       Min :  000; Max : 20000),
  //  
  ( XB : 510; YB : 40;       Title : '  1';    Min : -10;  Max : 10),
  ( XB : 510; YB : 40 + 140; Title : '  2';    Min : -10;  Max : 10),
  ( XB : 510; YB : 40 + 280; Title : '  3';    Min :  00;  Max : 20),
  ( XB : 510; YB : 40 + 420; Title : '  4';    Min :  00;  Max : 100)
);

// ================================================================
//    / 
// ================================================================
// ----------------------------------------------------------------
//   
procedure TSensorGroup01Form.FormCreate(Sender: TObject);
var Ind : integer;
begin
   for Ind := Low(SensorsArr01) to High(SensorsArr01)
   do begin
      if not Assigned(SensorsArr01[Ind])
      then begin
         SensorsArr01[Ind] := TSensor.Create(Panel1,
                              SensorsDesc[Ind].XB,
                              SensorsDesc[Ind].YB);
         with SensorsArr01[Ind]
         do begin
           Indx  := Ind;
           Title := SensorsDesc[Ind].Title;
           Min   := SensorsDesc[Ind].Min;
           Max   := SensorsDesc[Ind].Max;
         end;
      end;
   end;
   //    
   // Edit1.Text := IntToStr(AllocMemSize);
end;
// ----------------------------------------------------------------
//     
procedure TSensorGroup01Form.FormDestroy(Sender: TObject);
var Ind : integer;
begin
   for Ind := Low(SensorsArr01) to High(SensorsArr01)
   do begin
      if Assigned(SensorsArr01[Ind])
      then begin
       SensorsArr01[Ind].Free;
       SensorsArr01[Ind] := nil;
      end;
   end;
   //    
   // Edit1.Text := IntToStr(AllocMemSize);
end;
// ================================================================
//   
// ================================================================
end.
